<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
//use config\helpers;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Twilio\Rest\Client;
use DB;
use Mail;

class AccountController extends Controller
{
    // Login View
    public function login(){
        if(session()->get('id') != null){
            return redirect()->route('index');
        }else{
            return view('auth.login');
        }
    }

    //login submit
    public function checklogin(Request $request){

        $arr = [
            'email' => $request->email_address,
            'password' => sha1($request->password)
        ];

        $users = DB::table('users')->where($arr)->first();

        if($users != null){
            if($users->is_deleted == 0){
                $depart = DB::table("department_assign")->where('user_id', $users->id)->first();
                if(!empty($depart)){
                    $dep = DB::table('departments')->where('id',$depart->department_id)->first();
                    
                    $userrole = DB::table('usertype')->where('id',$users->usertype_id)->first();
                    
                    if($users->usertype_id == 2){
                        $user_sub_department = DB::table('sub_department_assign')
                                            ->select('sub_department_assign.sub_department_id', 'sub_department_assign.user_id', 'sub_departments.name as sub_department_name' )
                                            ->leftjoin('sub_departments', 'sub_departments.id','sub_department_assign.sub_department_id')
                                            ->where('sub_department_assign.user_id', $users->id)
                                            ->first();
                        $sesion_array = [
                            'id' => $users->id,
                            'name' => $users->first_name,
                            'email' => $users->email,
                            'image' => $users->image,
                            'parentid' => $users->parent_user_id,
                            'usertype' => $users->usertype_id,
                            'usertype_name' => $userrole->name,
                            'department' => $dep->name,
                            'department_id' => $depart->department_id,
                            'sub_department_id' => $user_sub_department->sub_department_id ?? null,
                            'sub_department_name' => $user_sub_department->sub_department_name ?? null,
                        ];
                    }else{
                        $sesion_array = [
                            'id' => $users->id,
                            'name' => $users->first_name,
                            'email' => $users->email,
                            'image' => $users->image,
                            'parentid' => $users->parent_user_id,
                            'usertype' => $users->usertype_id,
                            'usertype_name' => $userrole->name,
                            'department' => $dep->name,
                            'department_id' => $depart->department_id,
                        ];
                    }
                    

                    session()->put($sesion_array);
                    toastr()->success('Login Successful');
                    return redirect()->route('index');
                }
                else{
                    toastr()->error('Department is not assign');
                    return redirect()->route('login');
                }
            }
            else{
                toastr()->error('Your account is deactivated. Contact your admin');
                return redirect()->route('login');
            }
        }
        else{
            toastr()->error('Invalid Credentials');
            return redirect()->route('login');
        }
    }

    //logout
    public function logout(){
        session()->flush();
        return redirect()->route('login');
    }

    //signup
    public function signup(){
        return view('auth.signup');
    }

    //validate signup
    public function validate_signup(Request $request){
        $sid    = env( 'TWILIO_SID' );
        $token  = env( 'TWILIO_TOKEN' );
        $client = new Client( $sid, $token );

        $check_email = DB::table('users')->where('email',$request->email)->first();
        if(!empty($check_email)){
            toastr()->error('Email already exist');
            return redirect()->back();
        }
        else{
            $data = array(
                'first_name' => $request->first_name,
                'last_name' => $request->last_name,
                'email' => $request->email,
                'phone_number' => $request->phone_number,
                'password' => sha1($request->password),
                'status' => 1,
                'approval' => 'pending',
                'usertype_id' => $request->usertype,
                'is_deleted' => 0
            );

            $insert = DB::table('users')
                ->insertGetId($data);

            if(!empty($insert)){
                $fourdigitrandom = rand(1000,9999);
                $client->messages->create(
                    $data['phone_number'],
                    array(
                        'from' => env( 'TWILIO_FROM' ),
                        'body' => $fourdigitrandom
                    )
                );

                $otp_data = [
                    'opt_code' => $fourdigitrandom,
                    'status' => 'pending',
                    'user_id' => $insert,
                ];
                $insert_otp = DB::table('opt_factor')->insert($otp_data);
                if($insert_otp){
                    toastr()->success('Enter Your OTP Code');
                    return redirect()->route('otp',$insert);
                }
                else{
                    toastr()->error('Something went wrong');
                    return redirect()->back();
                }

            }else{
                return redirect()->back();
            }
        }
    }

    // User Profile
    public function profile(){

        if(session()->get('id') != null){
            $user = DB::table('users')->where('id',session()->get('id'))->first();
            return view('auth.profile', compact('user'));
        }else{
            return redirect()->route('login');
        }
    }
    
    public function profileUpdate(Request $request){
        $validate = $request->validate([
            'first_name' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'gender' => 'required',
        ]);

        $image = "";
        
        if($request->gender == "Male"){
            $image = "male.png";
        }
        else{
            $image = "female.png";
        }
        
        if($request->hasFile('file')){
            $file = $request->file('file');
            $image = uniqid().'.'.$file->guessExtension();
            $attachment_path = $file->move(public_path().'/backend/img/users/',$image);
        }
        else{
            $get_img = DB::table('users')->where('id', $request->user_id )->first();
            $image = $get_img->image;
        }
        
        if($request->password != null){
            $profile = [
                'first_name' => $request->first_name,
                'last_name' => $request->last_name,
                'email' => $request->email,
                'password' => sha1($request->password),
                'phone_number' => $request->phone,
                'cnic' => $request->cnic,
                'gender' => $request->gender,
                'address' => $request->address,
                'image' => $image,
            ];
        }else{
           $profile = [
                'first_name' => $request->first_name,
                'last_name' => $request->last_name,
                'email' => $request->email,
                'phone_number' => $request->phone,
                'cnic' => $request->cnic,
                'gender' => $request->gender,
                'address' => $request->address,
                'image' => $image,
            ]; 
        }
        

        $update = DB::table('users')->where('id', $request->user_id)->update($profile);
        if($update){
            $sesion_array = [
                'image' => $image,
            ];
            session()->put($sesion_array);
            toastr()->success('Profile Update Successfully');
            return redirect()->back();
        }else{
            toastr()->error('Something went wrong');
            return redirect()->back();
        }
    }
    
    // Account Redirection For Admin
    public function accountRedirect($id){
        
        
        $users = DB::table('users')->where('id', $id)->first();

        if($users != null){
            
            $depart = DB::table("department_assign")->where('user_id', $users->id)->first();
            if(!empty($depart)){
                $dep = DB::table('departments')->where('id',$depart->department_id)->first();
                
                $userrole = DB::table('usertype')->where('id',$users->usertype_id)->first();
                if($users->usertype_id == 1){
                    $sesion_array = [
                        'id' => $users->id,
                        'name' => $users->first_name,
                        'email' => $users->email,
                        'image' => $users->image,
                        'parentid' => $users->parent_user_id,
                        'usertype' => $users->usertype_id,
                        'usertype_name' => $userrole->name,
                        'department' => $dep->name,
                        'department_id' => $depart->department_id,
                        'admin_status' => 'in-active',
                    ];
                    
                }elseif($users->usertype_id == 2){
                    $user_sub_department = DB::table('sub_department_assign')
                                        ->select('sub_department_assign.sub_department_id', 'sub_department_assign.user_id', 'sub_departments.name as sub_department_name' )
                                        ->leftjoin('sub_departments', 'sub_departments.id','sub_department_assign.sub_department_id')
                                        ->where('sub_department_assign.user_id', $users->id)
                                        ->first();
                    $sesion_array = [
                        'id' => $users->id,
                        'name' => $users->first_name,
                        'email' => $users->email,
                        'image' => $users->image,
                        'parentid' => $users->parent_user_id,
                        'usertype' => $users->usertype_id,
                        'usertype_name' => $userrole->name,
                        'department' => $dep->name,
                        'department_id' => $depart->department_id,
                        'sub_department_id' => $user_sub_department->sub_department_id ?? null,
                        'sub_department_name' => $user_sub_department->sub_department_name ?? null,
                        'admin_status' => 'active',
                        'admin_id' => session()->get('id')
                    ];
                }else{
                    $sesion_array = [
                        'id' => $users->id,
                        'name' => $users->first_name,
                        'email' => $users->email,
                        'image' => $users->image,
                        'parentid' => $users->parent_user_id,
                        'usertype' => $users->usertype_id,
                        'usertype_name' => $userrole->name,
                        'department' => $dep->name,
                        'department_id' => $depart->department_id,
                        'admin_status' => 'active',
                        'admin_id' => session()->get('id')
                    ];
                }
                

                session()->put($sesion_array);
                toastr()->success('You are successfully entered');
                return redirect()->route('index');
            }
            else{
                toastr()->error('Department is not assign');
                return redirect()->route('login');
            }
        }
        else{
            toastr()->error('Invalid User');
            return redirect()->route('login');
        }
    }
}
